// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

/** The HealthcareLROResult model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("HealthcareLROResults")
@Fluent
public final class HealthcareLROResult extends AnalyzeTextLROResult {
    /*
     * The results property.
     */
    @JsonProperty(value = "results", required = true)
    private HealthcareResult results;

    /** Creates an instance of HealthcareLROResult class. */
    public HealthcareLROResult() {}

    /**
     * Get the results property: The results property.
     *
     * @return the results value.
     */
    public HealthcareResult getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     *
     * @param results the results value to set.
     * @return the HealthcareLROResult object itself.
     */
    public HealthcareLROResult setResults(HealthcareResult results) {
        this.results = results;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }
}
