// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** The HealthcareLROTask model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("Healthcare")
@Fluent
public final class HealthcareLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for a Healthcare task.
     */
    @JsonProperty(value = "parameters")
    private HealthcareTaskParameters parameters;

    /** Creates an instance of HealthcareLROTask class. */
    public HealthcareLROTask() {}

    /**
     * Get the parameters property: Supported parameters for a Healthcare task.
     *
     * @return the parameters value.
     */
    public HealthcareTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for a Healthcare task.
     *
     * @param parameters the parameters value to set.
     * @return the HealthcareLROTask object itself.
     */
    public HealthcareLROTask setParameters(HealthcareTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public HealthcareLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
