// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.models.HealthcareEntityRelationType;
import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/**
 * Every relation is an entity graph of a certain relationType, where all entities are connected and have specific roles
 * within the relation context.
 */
@Fluent
public final class HealthcareRelation {
    /*
     * Type of relation. Examples include: `DosageOfMedication` or 'FrequencyOfMedication', etc.
     */
    @JsonProperty(value = "relationType", required = true)
    private HealthcareEntityRelationType relationType;

    /*
     * Confidence score between 0 and 1 of the extracted relation.
     */
    @JsonProperty(value = "confidenceScore")
    private Double confidenceScore;

    /*
     * The entities in the relation.
     */
    @JsonProperty(value = "entities", required = true)
    private List<HealthcareRelationEntity> entities;

    /** Creates an instance of HealthcareRelation class. */
    public HealthcareRelation() {}

    /**
     * Get the relationType property: Type of relation. Examples include: `DosageOfMedication` or
     * 'FrequencyOfMedication', etc.
     *
     * @return the relationType value.
     */
    public HealthcareEntityRelationType getRelationType() {
        return this.relationType;
    }

    /**
     * Set the relationType property: Type of relation. Examples include: `DosageOfMedication` or
     * 'FrequencyOfMedication', etc.
     *
     * @param relationType the relationType value to set.
     * @return the HealthcareRelation object itself.
     */
    public HealthcareRelation setRelationType(HealthcareEntityRelationType relationType) {
        this.relationType = relationType;
        return this;
    }

    /**
     * Get the confidenceScore property: Confidence score between 0 and 1 of the extracted relation.
     *
     * @return the confidenceScore value.
     */
    public Double getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Set the confidenceScore property: Confidence score between 0 and 1 of the extracted relation.
     *
     * @param confidenceScore the confidenceScore value to set.
     * @return the HealthcareRelation object itself.
     */
    public HealthcareRelation setConfidenceScore(Double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    /**
     * Get the entities property: The entities in the relation.
     *
     * @return the entities value.
     */
    public List<HealthcareRelationEntity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: The entities in the relation.
     *
     * @param entities the entities value to set.
     * @return the HealthcareRelation object itself.
     */
    public HealthcareRelation setEntities(List<HealthcareRelationEntity> entities) {
        this.entities = entities;
        return this;
    }
}
