// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.time.OffsetDateTime;

/** The KeyPhraseExtractionLROResult model. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("KeyPhraseExtractionLROResults")
@Fluent
public final class KeyPhraseExtractionLROResult extends AnalyzeTextLROResult {
    /*
     * The results property.
     */
    @JsonProperty(value = "results", required = true)
    private KeyPhraseResult results;

    /** Creates an instance of KeyPhraseExtractionLROResult class. */
    public KeyPhraseExtractionLROResult() {}

    /**
     * Get the results property: The results property.
     *
     * @return the results value.
     */
    public KeyPhraseResult getResults() {
        return this.results;
    }

    /**
     * Set the results property: The results property.
     *
     * @param results the results value to set.
     * @return the KeyPhraseExtractionLROResult object itself.
     */
    public KeyPhraseExtractionLROResult setResults(KeyPhraseResult results) {
        this.results = results;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseExtractionLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseExtractionLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public KeyPhraseExtractionLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }
}
