// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;

/** The Match model. */
@Fluent
public final class Match {
    /*
     * If a well known item is recognized, a decimal number denoting the confidence level between 0 and 1 will be
     * returned.
     */
    @JsonProperty(value = "confidenceScore", required = true)
    private double confidenceScore;

    /*
     * Entity text as appears in the request.
     */
    @JsonProperty(value = "text", required = true)
    private String text;

    /*
     * Start position for the entity match text.
     */
    @JsonProperty(value = "offset", required = true)
    private int offset;

    /*
     * Length for the entity match text.
     */
    @JsonProperty(value = "length", required = true)
    private int length;

    /** Creates an instance of Match class. */
    public Match() {}

    /**
     * Get the confidenceScore property: If a well known item is recognized, a decimal number denoting the confidence
     * level between 0 and 1 will be returned.
     *
     * @return the confidenceScore value.
     */
    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Set the confidenceScore property: If a well known item is recognized, a decimal number denoting the confidence
     * level between 0 and 1 will be returned.
     *
     * @param confidenceScore the confidenceScore value to set.
     * @return the Match object itself.
     */
    public Match setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    /**
     * Get the text property: Entity text as appears in the request.
     *
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Entity text as appears in the request.
     *
     * @param text the text value to set.
     * @return the Match object itself.
     */
    public Match setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the offset property: Start position for the entity match text.
     *
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: Start position for the entity match text.
     *
     * @param offset the offset value to set.
     * @return the Match object itself.
     */
    public Match setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: Length for the entity match text.
     *
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: Length for the entity match text.
     *
     * @param length the length value to set.
     * @return the Match object itself.
     */
    public Match setLength(int length) {
        this.length = length;
        return this;
    }
}
