// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The MultiClassificationDocumentResult model. */
@Fluent
public class MultiClassificationDocumentResult extends DocumentResult {
    /*
     * The class property.
     */
    @JsonProperty(value = "class", required = true)
    private List<ClassificationResult> classProperty;

    /**
     * Get the classProperty property: The class property.
     *
     * @return the classProperty value.
     */
    public List<ClassificationResult> getClassProperty() {
        return this.classProperty;
    }

    /**
     * Set the classProperty property: The class property.
     *
     * @param classProperty the classProperty value to set.
     * @return the MultiClassificationDocumentResult object itself.
     */
    public MultiClassificationDocumentResult setClassProperty(List<ClassificationResult> classProperty) {
        this.classProperty = classProperty;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MultiClassificationDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MultiClassificationDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public MultiClassificationDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
