// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The PiiEntitiesDocumentResult model. */
@Fluent
public class PiiEntitiesDocumentResult extends DocumentResult {
    /*
     * Returns redacted text.
     */
    @JsonProperty(value = "redactedText", required = true)
    private String redactedText;

    /*
     * Recognized entities in the document.
     */
    @JsonProperty(value = "entities", required = true)
    private List<Entity> entities;

    /** Creates an instance of PiiEntitiesDocumentResult class. */
    public PiiEntitiesDocumentResult() {}

    /**
     * Get the redactedText property: Returns redacted text.
     *
     * @return the redactedText value.
     */
    public String getRedactedText() {
        return this.redactedText;
    }

    /**
     * Set the redactedText property: Returns redacted text.
     *
     * @param redactedText the redactedText value to set.
     * @return the PiiEntitiesDocumentResult object itself.
     */
    public PiiEntitiesDocumentResult setRedactedText(String redactedText) {
        this.redactedText = redactedText;
        return this;
    }

    /**
     * Get the entities property: Recognized entities in the document.
     *
     * @return the entities value.
     */
    public List<Entity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: Recognized entities in the document.
     *
     * @param entities the entities value to set.
     * @return the PiiEntitiesDocumentResult object itself.
     */
    public PiiEntitiesDocumentResult setEntities(List<Entity> entities) {
        this.entities = entities;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public PiiEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }
}
