// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;

/** The PreBuiltResult model. */
@Fluent
public class PreBuiltResult {
    /*
     * Errors by document id.
     */
    @JsonProperty(value = "errors", required = true)
    private List<DocumentError> errors;

    /*
     * if showStats=true was specified in the request this field will contain information about the request payload.
     */
    @JsonProperty(value = "statistics")
    private RequestStatistics statistics;

    /*
     * This field indicates which model is used for scoring.
     */
    @JsonProperty(value = "modelVersion", required = true)
    private String modelVersion;

    /** Creates an instance of PreBuiltResult class. */
    public PreBuiltResult() {}

    /**
     * Get the errors property: Errors by document id.
     *
     * @return the errors value.
     */
    public List<DocumentError> getErrors() {
        return this.errors;
    }

    /**
     * Set the errors property: Errors by document id.
     *
     * @param errors the errors value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setErrors(List<DocumentError> errors) {
        this.errors = errors;
        return this;
    }

    /**
     * Get the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     *
     * @return the statistics value.
     */
    public RequestStatistics getStatistics() {
        return this.statistics;
    }

    /**
     * Set the statistics property: if showStats=true was specified in the request this field will contain information
     * about the request payload.
     *
     * @param statistics the statistics value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setStatistics(RequestStatistics statistics) {
        this.statistics = statistics;
        return this;
    }

    /**
     * Get the modelVersion property: This field indicates which model is used for scoring.
     *
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: This field indicates which model is used for scoring.
     *
     * @param modelVersion the modelVersion value to set.
     * @return the PreBuiltResult object itself.
     */
    public PreBuiltResult setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }
}
