// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonTypeName;

/** An object representing the task definition for a Sentiment Analysis task. */
@JsonTypeInfo(use = JsonTypeInfo.Id.NAME, include = JsonTypeInfo.As.PROPERTY, property = "kind")
@JsonTypeName("SentimentAnalysis")
@Fluent
public final class SentimentAnalysisLROTask extends AnalyzeTextLROTask {
    /*
     * Supported parameters for a Sentiment Analysis task.
     */
    @JsonProperty(value = "parameters")
    private SentimentAnalysisTaskParameters parameters;

    /** Creates an instance of SentimentAnalysisLROTask class. */
    public SentimentAnalysisLROTask() {}

    /**
     * Get the parameters property: Supported parameters for a Sentiment Analysis task.
     *
     * @return the parameters value.
     */
    public SentimentAnalysisTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for a Sentiment Analysis task.
     *
     * @param parameters the parameters value to set.
     * @return the SentimentAnalysisLROTask object itself.
     */
    public SentimentAnalysisLROTask setParameters(SentimentAnalysisTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /** {@inheritDoc} */
    @Override
    public SentimentAnalysisLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }
}
