/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AbstractiveSummaryOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AbstractiveSummaryResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationLROResult;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationLROTask;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.AbstractiveSummarizationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOperationDetail;
import com.azure.ai.textanalytics.models.AbstractiveSummaryOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.AbstractiveSummaryPagedFlux;
import com.azure.ai.textanalytics.util.AbstractiveSummaryPagedIterable;
import com.azure.ai.textanalytics.util.AbstractiveSummaryResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class AbstractiveSummaryUtilClient {
    private final AnalyzeTextsImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;
    private static final ClientLogger LOGGER = new ClientLogger(AbstractiveSummaryUtilClient.class);

    AbstractiveSummaryUtilClient(AnalyzeTextsImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    PollerFlux<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedFlux> abstractiveSummaryAsync(Iterable<TextDocumentInput> documents, AbstractiveSummaryOptions options, Context context) {
        try {
            this.checkUnsupportedServiceVersionForAbstractiveSummary();
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAbstractiveSummaryOptions(options);
            Context finalContext = Utility.getNotNullContext(context);
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<AbstractiveSummaryOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(options.getDisplayName()).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new AbstractiveSummarizationLROTask().setParameters(new AbstractiveSummarizationTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setSentenceCount(options.getSentenceCount()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled())))), finalContext).map(responseBase -> {
                AbstractiveSummaryOperationDetail operationDetail = new AbstractiveSummaryOperationDetail();
                AbstractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperation(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperation(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperation(operationId -> Mono.just((Object)((Object)this.getAbstractiveSummaryPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    SyncPoller<AbstractiveSummaryOperationDetail, AbstractiveSummaryPagedIterable> abstractiveSummaryPagedIterable(Iterable<TextDocumentInput> documents, AbstractiveSummaryOptions options, Context context) {
        try {
            this.checkUnsupportedServiceVersionForAbstractiveSummary();
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullAbstractiveSummaryOptions(options);
            Context finalContext = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            String displayName = options.getDisplayName();
            AbstractiveSummarizationLROTask task = new AbstractiveSummarizationLROTask().setParameters(new AbstractiveSummarizationTaskParameters().setStringIndexType(StringIndexType.UTF16CODE_UNIT).setSentenceCount(options.getSentenceCount()).setModelVersion(options.getModelVersion()).setLoggingOptOut(options.isServiceLogsDisabled()));
            return SyncPoller.createPoller((Duration)Utility.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperationSync(documents, task, displayName, finalContext).apply((PollingContext<AbstractiveSummaryOperationDetail>)cxt)), this.pollingOperationSync(operationId -> this.service.jobStatusWithResponse((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationSync(operationId -> this.service.cancelJobWithResponse((UUID)operationId, finalContext)), this.fetchingOperationIterable(operationId -> this.getAbstractiveSummaryPagedIterable((UUID)operationId, null, null, finalIncludeStatistics, finalContext)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    AbstractiveSummaryPagedFlux getAbstractiveSummaryPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AbstractiveSummaryPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    AbstractiveSummaryPagedIterable getAbstractiveSummaryPagedIterable(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new AbstractiveSummaryPagedIterable(() -> (continuationToken, pageSize) -> this.getPagedResultSync((String)continuationToken, operationId, top, skip, showStats, context));
    }

    Mono<PagedResponse<AbstractiveSummaryResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                top = Utility.getTopContinuesToken(continuationTokenMap);
                skip = Utility.getSkipContinuesToken(continuationTokenMap);
                showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
            }
            return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toAbstractiveSummaryResultCollectionPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedResponse<AbstractiveSummaryResultCollection> getPagedResultSync(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        if (continuationToken != null) {
            Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
            top = Utility.getTopContinuesToken(continuationTokenMap);
            skip = Utility.getSkipContinuesToken(continuationTokenMap);
            showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
        }
        return this.toAbstractiveSummaryResultCollectionPagedResponse(this.service.jobStatusWithResponse(operationId, showStats, top, skip, context));
    }

    private PagedResponse<AbstractiveSummaryResultCollection> toAbstractiveSummaryResultCollectionPagedResponse(Response<AnalyzeTextJobState> response) {
        List<Error> errors;
        AnalyzeTextJobState jobState = (AnalyzeTextJobState)response.getValue();
        List<AnalyzeTextLROResult> lroResults = jobState.getTasks().getItems();
        AnalyzeTextLROResult lroResult = lroResults.get(0);
        if (!(lroResult instanceof AbstractiveSummarizationLROResult)) {
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid class type returned: " + lroResult.getClass().getName()));
        }
        AbstractiveSummarizationLROResult abstractiveSummarizationLROResult = (AbstractiveSummarizationLROResult)lroResults.get(0);
        AbstractiveSummarizationResult abstractiveSummarizationResult = abstractiveSummarizationLROResult.getResults();
        AbstractiveSummaryResultCollection abstractiveSummaryResultCollection = Utility.toAbstractiveSummaryResultCollection(abstractiveSummarizationResult);
        RequestStatistics requestStatistics = abstractiveSummarizationResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            AbstractiveSummaryResultCollectionPropertiesHelper.setStatistics(abstractiveSummaryResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = jobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Abstractive summary operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(abstractiveSummaryResultCollection), jobState.getNextLink(), null);
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, Mono<AbstractiveSummaryOperationDetail>> activationOperation(Mono<AbstractiveSummaryOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, AbstractiveSummaryOperationDetail> activationOperationSync(Iterable<TextDocumentInput> documents, AnalyzeTextLROTask task, String displayName, Context context) {
        return pollingContext -> {
            ResponseBase<AnalyzeTextsSubmitJobHeaders, Void> analyzeResponse = this.service.submitJobWithResponse(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(task)), context);
            AbstractiveSummaryOperationDetail operationDetail = new AbstractiveSummaryOperationDetail();
            AbstractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationDetail;
        };
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, Mono<PollResponse<AbstractiveSummaryOperationDetail>>> pollingOperation(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> Mono.just(this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<AbstractiveSummaryOperationDetail>)operationResultPollResponse))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, PollResponse<AbstractiveSummaryOperationDetail>> pollingOperationSync(Function<UUID, Response<AnalyzeTextJobState>> pollingFunction) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID operationId = UUID.fromString(((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue()).getOperationId());
            return this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)((Response)pollingFunction.apply(operationId)), (PollResponse<AbstractiveSummaryOperationDetail>)operationResultPollResponse);
        };
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, Mono<AbstractiveSummaryPagedFlux>> fetchingOperation(Function<UUID, Mono<AbstractiveSummaryPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((AbstractiveSummaryOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<AbstractiveSummaryOperationDetail>, AbstractiveSummaryPagedIterable> fetchingOperationIterable(Function<UUID, AbstractiveSummaryPagedIterable> fetchingFunction) {
        return pollingContext -> {
            UUID resultUuid = UUID.fromString(((AbstractiveSummaryOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
            return (AbstractiveSummaryPagedIterable)((Object)((Object)fetchingFunction.apply(resultUuid)));
        };
    }

    private BiFunction<PollingContext<AbstractiveSummaryOperationDetail>, PollResponse<AbstractiveSummaryOperationDetail>, Mono<AbstractiveSummaryOperationDetail>> cancelOperation(Function<UUID, Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((AbstractiveSummaryOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelJobResponse -> {
                    AbstractiveSummaryOperationDetail operationResult = new AbstractiveSummaryOperationDetail();
                    AbstractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<AbstractiveSummaryOperationDetail>, PollResponse<AbstractiveSummaryOperationDetail>, AbstractiveSummaryOperationDetail> cancelOperationSync(Function<UUID, ResponseBase<AnalyzeTextsCancelJobHeaders, Void>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((AbstractiveSummaryOperationDetail)pollingContext.getValue()).getOperationId());
            ResponseBase cancelJobResponse = (ResponseBase)cancelFunction.apply(resultUuid);
            AbstractiveSummaryOperationDetail operationResult = new AbstractiveSummaryOperationDetail();
            AbstractiveSummaryOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationResult;
        };
    }

    private PollResponse<AbstractiveSummaryOperationDetail> processAnalyzeTextModelResponse(Response<AnalyzeTextJobState> analyzeOperationResultResponse, PollResponse<AbstractiveSummaryOperationDetail> operationResultPollResponse) {
        State state = ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        AbstractiveSummaryOperationDetailPropertiesHelper.setDisplayName((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getDisplayName());
        AbstractiveSummaryOperationDetailPropertiesHelper.setCreatedAt((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        AbstractiveSummaryOperationDetailPropertiesHelper.setLastModifiedAt((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getLastUpdatedDateTime());
        AbstractiveSummaryOperationDetailPropertiesHelper.setExpiresAt((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return new PollResponse(status, (Object)((AbstractiveSummaryOperationDetail)operationResultPollResponse.getValue()));
    }

    private AbstractiveSummaryOptions getNotNullAbstractiveSummaryOptions(AbstractiveSummaryOptions options) {
        return options == null ? new AbstractiveSummaryOptions() : options;
    }

    private void checkUnsupportedServiceVersionForAbstractiveSummary() {
        Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1, TextAnalyticsServiceVersion.V2022_05_01), Utility.getUnsupportedServiceApiVersionMessage("Abstractive Summarization", this.serviceVersion, TextAnalyticsServiceVersion.V2023_04_01));
    }
}

