/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics;

import com.azure.ai.textanalytics.TextAnalyticsServiceVersion;
import com.azure.ai.textanalytics.implementation.AnalyzeTextsImpl;
import com.azure.ai.textanalytics.implementation.ClassifyDocumentOperationDetailPropertiesHelper;
import com.azure.ai.textanalytics.implementation.ClassifyDocumentResultCollectionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.TextAnalyticsExceptionPropertiesHelper;
import com.azure.ai.textanalytics.implementation.Utility;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobState;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextJobsInput;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsCancelJobHeaders;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextsSubmitJobHeaders;
import com.azure.ai.textanalytics.implementation.models.CustomLabelClassificationResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationLROResult;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationLROTask;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationTaskParameters;
import com.azure.ai.textanalytics.implementation.models.Error;
import com.azure.ai.textanalytics.implementation.models.ErrorResponseException;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.ai.textanalytics.implementation.models.RequestStatistics;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.ai.textanalytics.models.ClassifyDocumentOperationDetail;
import com.azure.ai.textanalytics.models.MultiLabelClassifyOptions;
import com.azure.ai.textanalytics.models.SingleLabelClassifyOptions;
import com.azure.ai.textanalytics.models.TextAnalyticsError;
import com.azure.ai.textanalytics.models.TextAnalyticsException;
import com.azure.ai.textanalytics.models.TextDocumentBatchStatistics;
import com.azure.ai.textanalytics.models.TextDocumentInput;
import com.azure.ai.textanalytics.util.ClassifyDocumentPagedFlux;
import com.azure.ai.textanalytics.util.ClassifyDocumentPagedIterable;
import com.azure.ai.textanalytics.util.ClassifyDocumentResultCollection;
import com.azure.core.http.rest.PagedResponse;
import com.azure.core.http.rest.PagedResponseBase;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.util.Context;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.IterableStream;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.core.util.polling.PollResponse;
import com.azure.core.util.polling.PollerFlux;
import com.azure.core.util.polling.PollingContext;
import com.azure.core.util.polling.SyncPoller;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class LabelClassifyUtilClient {
    private static final ClientLogger LOGGER = new ClientLogger(LabelClassifyUtilClient.class);
    private final AnalyzeTextsImpl service;
    private final TextAnalyticsServiceVersion serviceVersion;

    LabelClassifyUtilClient(AnalyzeTextsImpl service, TextAnalyticsServiceVersion serviceVersion) {
        this.service = service;
        this.serviceVersion = serviceVersion;
    }

    PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> singleLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, SingleLabelClassifyOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginSingleLabelClassify", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullSingleLabelClassifyOptions(options);
            Context finalContext = Utility.getNotNullContext(context);
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            String displayName = options.getDisplayName();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<ClassifyDocumentOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new CustomSingleLabelClassificationLROTask().setParameters(new CustomSingleLabelClassificationTaskParameters().setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(responseBase -> {
                ClassifyDocumentOperationDetail operationDetail = new ClassifyDocumentOperationDetail();
                ClassifyDocumentOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationTextJob(operationId -> Mono.just((Object)((Object)this.getClassifyDocumentPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> singleLabelClassifyPagedIterable(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, SingleLabelClassifyOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginSingleLabelClassify", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullSingleLabelClassifyOptions(options);
            Context finalContext = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            String displayName = options.getDisplayName();
            CustomSingleLabelClassificationLROTask task = new CustomSingleLabelClassificationLROTask().setParameters(new CustomSingleLabelClassificationTaskParameters().setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut));
            return SyncPoller.createPoller((Duration)Utility.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperationSync(documents, task, displayName, finalContext).apply((PollingContext<ClassifyDocumentOperationDetail>)cxt)), this.pollingOperationTextJobSync(operationId -> this.service.jobStatusWithResponse((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJobSync(operationId -> this.service.cancelJobWithResponse((UUID)operationId, finalContext)), this.fetchingOperationSync(operationId -> this.getClassifyDocumentPagedIterable((UUID)operationId, null, null, finalIncludeStatistics, finalContext)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    PollerFlux<ClassifyDocumentOperationDetail, ClassifyDocumentPagedFlux> multiLabelClassify(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, MultiLabelClassifyOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginMultiLabelClassify", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullMultiLabelClassifyOptions(options);
            Context finalContext = Utility.getNotNullContext(context);
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            String displayName = options.getDisplayName();
            return new PollerFlux(Utility.DEFAULT_POLL_INTERVAL, this.activationOperation((Mono<ClassifyDocumentOperationDetail>)this.service.submitJobWithResponseAsync(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(new CustomMultiLabelClassificationLROTask().setParameters(new CustomMultiLabelClassificationTaskParameters().setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut)))), finalContext).map(responseBase -> {
                ClassifyDocumentOperationDetail operationDetail = new ClassifyDocumentOperationDetail();
                ClassifyDocumentOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)responseBase.getDeserializedHeaders()).getOperationLocation()));
                return operationDetail;
            })), this.pollingOperationTextJob(operationId -> this.service.jobStatusWithResponseAsync((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJob(operationId -> this.service.cancelJobWithResponseAsync((UUID)operationId, finalContext)), this.fetchingOperationTextJob(operationId -> Mono.just((Object)((Object)this.getClassifyDocumentPagedFlux((UUID)operationId, null, null, finalIncludeStatistics, finalContext)))));
        }
        catch (RuntimeException ex) {
            return PollerFlux.error((Exception)ex);
        }
    }

    SyncPoller<ClassifyDocumentOperationDetail, ClassifyDocumentPagedIterable> multiLabelClassifyPagedIterable(Iterable<TextDocumentInput> documents, String projectName, String deploymentName, MultiLabelClassifyOptions options, Context context) {
        try {
            Utility.throwIfTargetServiceVersionFound(this.serviceVersion, Arrays.asList(TextAnalyticsServiceVersion.V3_0, TextAnalyticsServiceVersion.V3_1), Utility.getUnsupportedServiceApiVersionMessage("beginMultiLabelClassify", this.serviceVersion, TextAnalyticsServiceVersion.V2022_05_01));
            Utility.inputDocumentsValidation(documents);
            options = this.getNotNullMultiLabelClassifyOptions(options);
            Context finalContext = Utility.enableSyncRestProxy(Utility.getNotNullContext(context));
            boolean finalIncludeStatistics = options.isIncludeStatistics();
            boolean finalLoggingOptOut = options.isServiceLogsDisabled();
            String displayName = options.getDisplayName();
            CustomMultiLabelClassificationLROTask task = new CustomMultiLabelClassificationLROTask().setParameters(new CustomMultiLabelClassificationTaskParameters().setProjectName(projectName).setDeploymentName(deploymentName).setLoggingOptOut(finalLoggingOptOut));
            return SyncPoller.createPoller((Duration)Utility.DEFAULT_POLL_INTERVAL, cxt -> new PollResponse(LongRunningOperationStatus.NOT_STARTED, (Object)this.activationOperationSync(documents, task, displayName, finalContext).apply((PollingContext<ClassifyDocumentOperationDetail>)cxt)), this.pollingOperationTextJobSync(operationId -> this.service.jobStatusWithResponse((UUID)operationId, finalIncludeStatistics, null, null, finalContext)), this.cancelOperationTextJobSync(operationId -> this.service.cancelJobWithResponse((UUID)operationId, finalContext)), this.fetchingOperationSync(operationId -> this.getClassifyDocumentPagedIterable((UUID)operationId, null, null, finalIncludeStatistics, finalContext)));
        }
        catch (ErrorResponseException ex) {
            throw LOGGER.logExceptionAsError((RuntimeException)Utility.getHttpResponseException(ex));
        }
    }

    ClassifyDocumentPagedFlux getClassifyDocumentPagedFlux(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new ClassifyDocumentPagedFlux(() -> (continuationToken, pageSize) -> this.getPagedResult((String)continuationToken, operationId, top, skip, showStats, context).flux());
    }

    ClassifyDocumentPagedIterable getClassifyDocumentPagedIterable(UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        return new ClassifyDocumentPagedIterable(() -> (continuationToken, pageSize) -> this.getPagedResultSync((String)continuationToken, operationId, top, skip, showStats, context));
    }

    Mono<PagedResponse<ClassifyDocumentResultCollection>> getPagedResult(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        try {
            if (continuationToken != null) {
                Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
                top = Utility.getTopContinuesToken(continuationTokenMap);
                skip = Utility.getSkipContinuesToken(continuationTokenMap);
                showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
            }
            return this.service.jobStatusWithResponseAsync(operationId, showStats, top, skip, context).map(this::toClassifyDocumentResultCollectionPagedResponse).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
        }
        catch (RuntimeException ex) {
            return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
        }
    }

    PagedResponse<ClassifyDocumentResultCollection> getPagedResultSync(String continuationToken, UUID operationId, Integer top, Integer skip, boolean showStats, Context context) {
        if (continuationToken != null) {
            Map<String, Object> continuationTokenMap = Utility.parseNextLink(continuationToken);
            top = Utility.getTopContinuesToken(continuationTokenMap);
            skip = Utility.getSkipContinuesToken(continuationTokenMap);
            showStats = Utility.getShowStatsContinuesToken(continuationTokenMap);
        }
        return this.toClassifyDocumentResultCollectionPagedResponse(this.service.jobStatusWithResponse(operationId, showStats, top, skip, context));
    }

    private PagedResponse<ClassifyDocumentResultCollection> toClassifyDocumentResultCollectionPagedResponse(Response<AnalyzeTextJobState> response) {
        List<Error> errors;
        CustomLabelClassificationResult customLabelClassificationResult;
        AnalyzeTextJobState jobState = (AnalyzeTextJobState)response.getValue();
        List<AnalyzeTextLROResult> lroResults = jobState.getTasks().getItems();
        AnalyzeTextLROResult lroResult = lroResults.get(0);
        if (lroResult instanceof CustomSingleLabelClassificationLROResult) {
            CustomSingleLabelClassificationLROResult customSingleLabelClassificationLROResult = (CustomSingleLabelClassificationLROResult)lroResults.get(0);
            customLabelClassificationResult = customSingleLabelClassificationLROResult.getResults();
        } else if (lroResult instanceof CustomMultiLabelClassificationLROResult) {
            CustomMultiLabelClassificationLROResult customMultiLabelClassificationLROResult = (CustomMultiLabelClassificationLROResult)lroResults.get(0);
            customLabelClassificationResult = customMultiLabelClassificationLROResult.getResults();
        } else {
            throw LOGGER.logExceptionAsError(new RuntimeException("Invalid class type returned: " + lroResult.getClass().getName()));
        }
        ClassifyDocumentResultCollection classifyDocumentResultCollection = Utility.toLabelClassificationResultCollection(customLabelClassificationResult);
        RequestStatistics requestStatistics = customLabelClassificationResult.getStatistics();
        if (requestStatistics != null) {
            TextDocumentBatchStatistics batchStatistic = new TextDocumentBatchStatistics(requestStatistics.getDocumentsCount(), requestStatistics.getValidDocumentsCount(), requestStatistics.getErroneousDocumentsCount(), requestStatistics.getTransactionsCount());
            ClassifyDocumentResultCollectionPropertiesHelper.setStatistics(classifyDocumentResultCollection, batchStatistic);
        }
        if (!CoreUtils.isNullOrEmpty(errors = jobState.getErrors())) {
            TextAnalyticsException textAnalyticsException = new TextAnalyticsException("Classify label operation failed", null, null);
            IterableStream textAnalyticsErrors = IterableStream.of((Iterable)errors.stream().map(Utility::toTextAnalyticsError).collect(Collectors.toList()));
            TextAnalyticsExceptionPropertiesHelper.setErrors(textAnalyticsException, (IterableStream<TextAnalyticsError>)textAnalyticsErrors);
            throw LOGGER.logExceptionAsError((RuntimeException)((Object)textAnalyticsException));
        }
        return new PagedResponseBase(response.getRequest(), response.getStatusCode(), response.getHeaders(), Arrays.asList(classifyDocumentResultCollection), jobState.getNextLink(), null);
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, Mono<ClassifyDocumentOperationDetail>> activationOperation(Mono<ClassifyDocumentOperationDetail> operationResult) {
        return pollingContext -> {
            try {
                return operationResult.onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, ClassifyDocumentOperationDetail> activationOperationSync(Iterable<TextDocumentInput> documents, AnalyzeTextLROTask task, String displayName, Context context) {
        return pollingContext -> {
            ResponseBase<AnalyzeTextsSubmitJobHeaders, Void> analyzeResponse = this.service.submitJobWithResponse(new AnalyzeTextJobsInput().setDisplayName(displayName).setAnalysisInput(new MultiLanguageAnalysisInput().setDocuments(Utility.toMultiLanguageInput(documents))).setTasks(Arrays.asList(task)), context);
            ClassifyDocumentOperationDetail operationDetail = new ClassifyDocumentOperationDetail();
            ClassifyDocumentOperationDetailPropertiesHelper.setOperationId(operationDetail, Utility.parseOperationId(((AnalyzeTextsSubmitJobHeaders)analyzeResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationDetail;
        };
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, Mono<PollResponse<ClassifyDocumentOperationDetail>>> pollingOperationTextJob(Function<UUID, Mono<Response<AnalyzeTextJobState>>> pollingFunction) {
        return pollingContext -> {
            try {
                PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
                UUID operationId = UUID.fromString(((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue()).getOperationId());
                return ((Mono)pollingFunction.apply(operationId)).flatMap(modelResponse -> Mono.just(this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)modelResponse, (PollResponse<ClassifyDocumentOperationDetail>)operationResultPollResponse))).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, PollResponse<ClassifyDocumentOperationDetail>> pollingOperationTextJobSync(Function<UUID, Response<AnalyzeTextJobState>> pollingFunction) {
        return pollingContext -> {
            PollResponse operationResultPollResponse = pollingContext.getLatestResponse();
            UUID operationId = UUID.fromString(((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue()).getOperationId());
            return this.processAnalyzeTextModelResponse((Response<AnalyzeTextJobState>)((Response)pollingFunction.apply(operationId)), (PollResponse<ClassifyDocumentOperationDetail>)operationResultPollResponse);
        };
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, Mono<ClassifyDocumentPagedFlux>> fetchingOperationTextJob(Function<UUID, Mono<ClassifyDocumentPagedFlux>> fetchingFunction) {
        return pollingContext -> {
            try {
                UUID resultUuid = UUID.fromString(((ClassifyDocumentOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
                return (Mono)fetchingFunction.apply(resultUuid);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private Function<PollingContext<ClassifyDocumentOperationDetail>, ClassifyDocumentPagedIterable> fetchingOperationSync(Function<UUID, ClassifyDocumentPagedIterable> fetchingFunction) {
        return pollingContext -> {
            UUID resultUuid = UUID.fromString(((ClassifyDocumentOperationDetail)pollingContext.getLatestResponse().getValue()).getOperationId());
            return (ClassifyDocumentPagedIterable)((Object)((Object)fetchingFunction.apply(resultUuid)));
        };
    }

    private BiFunction<PollingContext<ClassifyDocumentOperationDetail>, PollResponse<ClassifyDocumentOperationDetail>, Mono<ClassifyDocumentOperationDetail>> cancelOperationTextJob(Function<UUID, Mono<ResponseBase<AnalyzeTextsCancelJobHeaders, Void>>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((ClassifyDocumentOperationDetail)pollingContext.getValue()).getOperationId());
            try {
                return ((Mono)cancelFunction.apply(resultUuid)).map(cancelJobResponse -> {
                    ClassifyDocumentOperationDetail operationResult = new ClassifyDocumentOperationDetail();
                    ClassifyDocumentOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
                    return operationResult;
                }).onErrorMap(Utility::mapToHttpResponseExceptionIfExists);
            }
            catch (RuntimeException ex) {
                return FluxUtil.monoError((ClientLogger)LOGGER, (RuntimeException)ex);
            }
        };
    }

    private BiFunction<PollingContext<ClassifyDocumentOperationDetail>, PollResponse<ClassifyDocumentOperationDetail>, ClassifyDocumentOperationDetail> cancelOperationTextJobSync(Function<UUID, ResponseBase<AnalyzeTextsCancelJobHeaders, Void>> cancelFunction) {
        return (activationResponse, pollingContext) -> {
            UUID resultUuid = UUID.fromString(((ClassifyDocumentOperationDetail)pollingContext.getValue()).getOperationId());
            ResponseBase cancelJobResponse = (ResponseBase)cancelFunction.apply(resultUuid);
            ClassifyDocumentOperationDetail operationResult = new ClassifyDocumentOperationDetail();
            ClassifyDocumentOperationDetailPropertiesHelper.setOperationId(operationResult, Utility.parseOperationId(((AnalyzeTextsCancelJobHeaders)cancelJobResponse.getDeserializedHeaders()).getOperationLocation()));
            return operationResult;
        };
    }

    private PollResponse<ClassifyDocumentOperationDetail> processAnalyzeTextModelResponse(Response<AnalyzeTextJobState> analyzeOperationResultResponse, PollResponse<ClassifyDocumentOperationDetail> operationResultPollResponse) {
        State state = ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus();
        LongRunningOperationStatus status = State.NOT_STARTED.equals((Object)state) || State.RUNNING.equals((Object)state) ? LongRunningOperationStatus.IN_PROGRESS : (State.SUCCEEDED.equals((Object)state) ? LongRunningOperationStatus.SUCCESSFULLY_COMPLETED : (State.CANCELLED.equals((Object)state) ? LongRunningOperationStatus.USER_CANCELLED : LongRunningOperationStatus.fromString((String)((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getStatus().toString(), (boolean)true)));
        ClassifyDocumentOperationDetailPropertiesHelper.setDisplayName((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getDisplayName());
        ClassifyDocumentOperationDetailPropertiesHelper.setCreatedAt((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getCreatedDateTime());
        ClassifyDocumentOperationDetailPropertiesHelper.setLastModifiedAt((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getLastUpdatedDateTime());
        ClassifyDocumentOperationDetailPropertiesHelper.setExpiresAt((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue(), ((AnalyzeTextJobState)analyzeOperationResultResponse.getValue()).getExpirationDateTime());
        return new PollResponse(status, (Object)((ClassifyDocumentOperationDetail)operationResultPollResponse.getValue()));
    }

    private SingleLabelClassifyOptions getNotNullSingleLabelClassifyOptions(SingleLabelClassifyOptions options) {
        return options == null ? new SingleLabelClassifyOptions() : options;
    }

    private MultiLabelClassifyOptions getNotNullMultiLabelClassifyOptions(MultiLabelClassifyOptions options) {
        return options == null ? new MultiLabelClassifyOptions() : options;
    }
}

