/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskParameters;
import com.azure.ai.textanalytics.implementation.models.MultiLanguageAnalysisInput;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class AnalyzeTextEntityRecognitionInput
extends AnalyzeTextTask {
    private MultiLanguageAnalysisInput analysisInput;
    private EntitiesTaskParameters parameters;

    public MultiLanguageAnalysisInput getAnalysisInput() {
        return this.analysisInput;
    }

    public AnalyzeTextEntityRecognitionInput setAnalysisInput(MultiLanguageAnalysisInput analysisInput) {
        this.analysisInput = analysisInput;
        return this;
    }

    public EntitiesTaskParameters getParameters() {
        return this.parameters;
    }

    public AnalyzeTextEntityRecognitionInput setParameters(EntitiesTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskKind.ENTITY_RECOGNITION, null));
        jsonWriter.writeJsonField("analysisInput", (JsonSerializable)this.analysisInput);
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static AnalyzeTextEntityRecognitionInput fromJson(JsonReader jsonReader) throws IOException {
        return (AnalyzeTextEntityRecognitionInput)jsonReader.readObject(reader -> {
            AnalyzeTextEntityRecognitionInput deserializedAnalyzeTextEntityRecognitionInput = new AnalyzeTextEntityRecognitionInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityRecognition".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityRecognition'. The found 'kind' was '" + kind + "'.");
                }
                if ("analysisInput".equals(fieldName)) {
                    deserializedAnalyzeTextEntityRecognitionInput.analysisInput = MultiLanguageAnalysisInput.fromJson(reader);
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedAnalyzeTextEntityRecognitionInput.parameters = EntitiesTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAnalyzeTextEntityRecognitionInput;
        });
    }
}

