/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.CustomEntitiesTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CustomEntitiesLROTask
extends AnalyzeTextLROTask {
    private CustomEntitiesTaskParameters parameters;

    public CustomEntitiesTaskParameters getParameters() {
        return this.parameters;
    }

    public CustomEntitiesLROTask setParameters(CustomEntitiesTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public CustomEntitiesLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.CUSTOM_ENTITY_RECOGNITION, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static CustomEntitiesLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntitiesLROTask)jsonReader.readObject(reader -> {
            CustomEntitiesLROTask deserializedCustomEntitiesLROTask = new CustomEntitiesLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("CustomEntityRecognition".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'CustomEntityRecognition'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedCustomEntitiesLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedCustomEntitiesLROTask.parameters = CustomEntitiesTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomEntitiesLROTask;
        });
    }
}

