/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.CustomTaskParameters;
import com.azure.ai.textanalytics.implementation.models.StringIndexType;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CustomEntitiesTaskParameters
extends CustomTaskParameters {
    private StringIndexType stringIndexType;

    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    public CustomEntitiesTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    @Override
    public CustomEntitiesTaskParameters setProjectName(String projectName) {
        super.setProjectName(projectName);
        return this;
    }

    @Override
    public CustomEntitiesTaskParameters setDeploymentName(String deploymentName) {
        super.setDeploymentName(deploymentName);
        return this;
    }

    @Override
    public CustomEntitiesTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("projectName", this.getProjectName());
        jsonWriter.writeStringField("deploymentName", this.getDeploymentName());
        jsonWriter.writeBooleanField("loggingOptOut", this.isLoggingOptOut());
        jsonWriter.writeStringField("stringIndexType", Objects.toString((Object)this.stringIndexType, null));
        return jsonWriter.writeEndObject();
    }

    public static CustomEntitiesTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return (CustomEntitiesTaskParameters)jsonReader.readObject(reader -> {
            CustomEntitiesTaskParameters deserializedCustomEntitiesTaskParameters = new CustomEntitiesTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("projectName".equals(fieldName)) {
                    deserializedCustomEntitiesTaskParameters.setProjectName(reader.getString());
                    continue;
                }
                if ("deploymentName".equals(fieldName)) {
                    deserializedCustomEntitiesTaskParameters.setDeploymentName(reader.getString());
                    continue;
                }
                if ("loggingOptOut".equals(fieldName)) {
                    deserializedCustomEntitiesTaskParameters.setLoggingOptOut((Boolean)reader.getNullable(JsonReader::getBoolean));
                    continue;
                }
                if ("stringIndexType".equals(fieldName)) {
                    deserializedCustomEntitiesTaskParameters.stringIndexType = StringIndexType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomEntitiesTaskParameters;
        });
    }
}

