/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.CustomMultiLabelClassificationTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CustomMultiLabelClassificationLROTask
extends AnalyzeTextLROTask {
    private CustomMultiLabelClassificationTaskParameters parameters;

    public CustomMultiLabelClassificationTaskParameters getParameters() {
        return this.parameters;
    }

    public CustomMultiLabelClassificationLROTask setParameters(CustomMultiLabelClassificationTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public CustomMultiLabelClassificationLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.CUSTOM_MULTI_LABEL_CLASSIFICATION, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static CustomMultiLabelClassificationLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (CustomMultiLabelClassificationLROTask)jsonReader.readObject(reader -> {
            CustomMultiLabelClassificationLROTask deserializedCustomMultiLabelClassificationLROTask = new CustomMultiLabelClassificationLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("CustomMultiLabelClassification".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'CustomMultiLabelClassification'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedCustomMultiLabelClassificationLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedCustomMultiLabelClassificationLROTask.parameters = CustomMultiLabelClassificationTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomMultiLabelClassificationLROTask;
        });
    }
}

