/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.CustomLabelClassificationResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class CustomSingleLabelClassificationLROResult
extends AnalyzeTextLROResult {
    private CustomLabelClassificationResult results;

    public CustomLabelClassificationResult getResults() {
        return this.results;
    }

    public CustomSingleLabelClassificationLROResult setResults(CustomLabelClassificationResult results) {
        this.results = results;
        return this;
    }

    @Override
    public CustomSingleLabelClassificationLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public CustomSingleLabelClassificationLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public CustomSingleLabelClassificationLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROResultsKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION_LRORESULTS, null));
        jsonWriter.writeStringField("lastUpdateDateTime", Objects.toString(this.getLastUpdateDateTime(), null));
        jsonWriter.writeStringField("status", Objects.toString((Object)this.getStatus(), null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static CustomSingleLabelClassificationLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (CustomSingleLabelClassificationLROResult)jsonReader.readObject(reader -> {
            CustomSingleLabelClassificationLROResult deserializedCustomSingleLabelClassificationLROResult = new CustomSingleLabelClassificationLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("CustomSingleLabelClassificationLROResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'CustomSingleLabelClassificationLROResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROResult.results = CustomLabelClassificationResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomSingleLabelClassificationLROResult;
        });
    }
}

