/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.CustomSingleLabelClassificationTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class CustomSingleLabelClassificationLROTask
extends AnalyzeTextLROTask {
    private CustomSingleLabelClassificationTaskParameters parameters;

    public CustomSingleLabelClassificationTaskParameters getParameters() {
        return this.parameters;
    }

    public CustomSingleLabelClassificationLROTask setParameters(CustomSingleLabelClassificationTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public CustomSingleLabelClassificationLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.CUSTOM_SINGLE_LABEL_CLASSIFICATION, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static CustomSingleLabelClassificationLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (CustomSingleLabelClassificationLROTask)jsonReader.readObject(reader -> {
            CustomSingleLabelClassificationLROTask deserializedCustomSingleLabelClassificationLROTask = new CustomSingleLabelClassificationLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("CustomSingleLabelClassification".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'CustomSingleLabelClassification'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedCustomSingleLabelClassificationLROTask.parameters = CustomSingleLabelClassificationTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedCustomSingleLabelClassificationLROTask;
        });
    }
}

