/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.WarningCodeValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class DocumentWarning
implements JsonSerializable<DocumentWarning> {
    private WarningCodeValue code;
    private String message;
    private String targetRef;

    public WarningCodeValue getCode() {
        return this.code;
    }

    public DocumentWarning setCode(WarningCodeValue code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public DocumentWarning setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTargetRef() {
        return this.targetRef;
    }

    public DocumentWarning setTargetRef(String targetRef) {
        this.targetRef = targetRef;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", Objects.toString((Object)this.code, null));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("targetRef", this.targetRef);
        return jsonWriter.writeEndObject();
    }

    public static DocumentWarning fromJson(JsonReader jsonReader) throws IOException {
        return (DocumentWarning)jsonReader.readObject(reader -> {
            DocumentWarning deserializedDocumentWarning = new DocumentWarning();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedDocumentWarning.code = WarningCodeValue.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedDocumentWarning.message = reader.getString();
                    continue;
                }
                if ("targetRef".equals(fieldName)) {
                    deserializedDocumentWarning.targetRef = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedDocumentWarning;
        });
    }
}

