/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class EntitiesLROTask
extends AnalyzeTextLROTask {
    private EntitiesTaskParameters parameters;

    public EntitiesTaskParameters getParameters() {
        return this.parameters;
    }

    public EntitiesLROTask setParameters(EntitiesTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public EntitiesLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.ENTITY_RECOGNITION, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static EntitiesLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (EntitiesLROTask)jsonReader.readObject(reader -> {
            EntitiesLROTask deserializedEntitiesLROTask = new EntitiesLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityRecognition".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityRecognition'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedEntitiesLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedEntitiesLROTask.parameters = EntitiesTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntitiesLROTask;
        });
    }
}

