/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class EntitiesTaskResult
extends AnalyzeTextTaskResult {
    private EntitiesResult results;

    public EntitiesResult getResults() {
        return this.results;
    }

    public EntitiesTaskResult setResults(EntitiesResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskResultsKind.ENTITY_RECOGNITION_RESULTS, null));
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static EntitiesTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntitiesTaskResult)jsonReader.readObject(reader -> {
            EntitiesTaskResult deserializedEntitiesTaskResult = new EntitiesTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityRecognitionResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityRecognitionResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("results".equals(fieldName)) {
                    deserializedEntitiesTaskResult.results = EntitiesResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntitiesTaskResult;
        });
    }
}

