/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class EntityLinkingLROResult
extends AnalyzeTextLROResult {
    private EntityLinkingResult results;

    public EntityLinkingResult getResults() {
        return this.results;
    }

    public EntityLinkingLROResult setResults(EntityLinkingResult results) {
        this.results = results;
        return this;
    }

    @Override
    public EntityLinkingLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public EntityLinkingLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public EntityLinkingLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROResultsKind.ENTITY_LINKING_LRORESULTS, null));
        jsonWriter.writeStringField("lastUpdateDateTime", Objects.toString(this.getLastUpdateDateTime(), null));
        jsonWriter.writeStringField("status", Objects.toString((Object)this.getStatus(), null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingLROResult)jsonReader.readObject(reader -> {
            EntityLinkingLROResult deserializedEntityLinkingLROResult = new EntityLinkingLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityLinkingLROResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityLinkingLROResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedEntityLinkingLROResult.results = EntityLinkingResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingLROResult;
        });
    }
}

