/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class EntityLinkingLROTask
extends AnalyzeTextLROTask {
    private EntityLinkingTaskParameters parameters;

    public EntityLinkingTaskParameters getParameters() {
        return this.parameters;
    }

    public EntityLinkingLROTask setParameters(EntityLinkingTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public EntityLinkingLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.ENTITY_LINKING, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingLROTask)jsonReader.readObject(reader -> {
            EntityLinkingLROTask deserializedEntityLinkingLROTask = new EntityLinkingLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityLinking".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityLinking'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedEntityLinkingLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedEntityLinkingLROTask.parameters = EntityLinkingTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingLROTask;
        });
    }
}

