/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntityLinkingResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class EntityLinkingTaskResult
extends AnalyzeTextTaskResult {
    private EntityLinkingResult results;

    public EntityLinkingResult getResults() {
        return this.results;
    }

    public EntityLinkingTaskResult setResults(EntityLinkingResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskResultsKind.ENTITY_LINKING_RESULTS, null));
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static EntityLinkingTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntityLinkingTaskResult)jsonReader.readObject(reader -> {
            EntityLinkingTaskResult deserializedEntityLinkingTaskResult = new EntityLinkingTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityLinkingResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityLinkingResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("results".equals(fieldName)) {
                    deserializedEntityLinkingTaskResult.results = EntityLinkingResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityLinkingTaskResult;
        });
    }
}

