/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.EntitiesResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class EntityRecognitionLROResult
extends AnalyzeTextLROResult {
    private EntitiesResult results;

    public EntitiesResult getResults() {
        return this.results;
    }

    public EntityRecognitionLROResult setResults(EntitiesResult results) {
        this.results = results;
        return this;
    }

    @Override
    public EntityRecognitionLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public EntityRecognitionLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public EntityRecognitionLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROResultsKind.ENTITY_RECOGNITION_LRORESULTS, null));
        jsonWriter.writeStringField("lastUpdateDateTime", Objects.toString(this.getLastUpdateDateTime(), null));
        jsonWriter.writeStringField("status", Objects.toString((Object)this.getStatus(), null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static EntityRecognitionLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (EntityRecognitionLROResult)jsonReader.readObject(reader -> {
            EntityRecognitionLROResult deserializedEntityRecognitionLROResult = new EntityRecognitionLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("EntityRecognitionLROResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'EntityRecognitionLROResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedEntityRecognitionLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedEntityRecognitionLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedEntityRecognitionLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedEntityRecognitionLROResult.results = EntitiesResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedEntityRecognitionLROResult;
        });
    }
}

