/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.ErrorCode;
import com.azure.ai.textanalytics.implementation.models.InnerErrorModel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public final class Error
implements JsonSerializable<Error> {
    private ErrorCode code;
    private String message;
    private String target;
    private List<Error> details;
    private InnerErrorModel innererror;
    private Map<String, Object> additionalProperties;

    public ErrorCode getCode() {
        return this.code;
    }

    public Error setCode(ErrorCode code) {
        this.code = code;
        return this;
    }

    public String getMessage() {
        return this.message;
    }

    public Error setMessage(String message) {
        this.message = message;
        return this;
    }

    public String getTarget() {
        return this.target;
    }

    public Error setTarget(String target) {
        this.target = target;
        return this;
    }

    public List<Error> getDetails() {
        return this.details;
    }

    public Error setDetails(List<Error> details) {
        this.details = details;
        return this;
    }

    public InnerErrorModel getInnererror() {
        return this.innererror;
    }

    public Error setInnererror(InnerErrorModel innererror) {
        this.innererror = innererror;
        return this;
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public Error setAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", Objects.toString((Object)this.code, null));
        jsonWriter.writeStringField("message", this.message);
        jsonWriter.writeStringField("target", this.target);
        jsonWriter.writeArrayField("details", this.details, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("innererror", (JsonSerializable)this.innererror);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static Error fromJson(JsonReader jsonReader) throws IOException {
        return (Error)jsonReader.readObject(reader -> {
            Error deserializedError = new Error();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    deserializedError.code = ErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    deserializedError.message = reader.getString();
                    continue;
                }
                if ("target".equals(fieldName)) {
                    deserializedError.target = reader.getString();
                    continue;
                }
                if ("details".equals(fieldName)) {
                    List details;
                    deserializedError.details = details = reader.readArray(reader1 -> Error.fromJson(reader1));
                    continue;
                }
                if ("innererror".equals(fieldName)) {
                    deserializedError.innererror = InnerErrorModel.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedError.additionalProperties = additionalProperties;
            return deserializedError;
        });
    }
}

