/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.ExtractiveSummarizationResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class ExtractiveSummarizationLROResult
extends AnalyzeTextLROResult {
    private ExtractiveSummarizationResult results;

    public ExtractiveSummarizationResult getResults() {
        return this.results;
    }

    public ExtractiveSummarizationLROResult setResults(ExtractiveSummarizationResult results) {
        this.results = results;
        return this;
    }

    @Override
    public ExtractiveSummarizationLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public ExtractiveSummarizationLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public ExtractiveSummarizationLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROResultsKind.EXTRACTIVE_SUMMARIZATION_LRORESULTS, null));
        jsonWriter.writeStringField("lastUpdateDateTime", Objects.toString(this.getLastUpdateDateTime(), null));
        jsonWriter.writeStringField("status", Objects.toString((Object)this.getStatus(), null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static ExtractiveSummarizationLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (ExtractiveSummarizationLROResult)jsonReader.readObject(reader -> {
            ExtractiveSummarizationLROResult deserializedExtractiveSummarizationLROResult = new ExtractiveSummarizationLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("ExtractiveSummarizationLROResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'ExtractiveSummarizationLROResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedExtractiveSummarizationLROResult.results = ExtractiveSummarizationResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedExtractiveSummarizationLROResult;
        });
    }
}

