/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.HealthcareTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class HealthcareLROTask
extends AnalyzeTextLROTask {
    private HealthcareTaskParameters parameters;

    public HealthcareTaskParameters getParameters() {
        return this.parameters;
    }

    public HealthcareLROTask setParameters(HealthcareTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public HealthcareLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.HEALTHCARE, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static HealthcareLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareLROTask)jsonReader.readObject(reader -> {
            HealthcareLROTask deserializedHealthcareLROTask = new HealthcareLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("Healthcare".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'Healthcare'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedHealthcareLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedHealthcareLROTask.parameters = HealthcareTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareLROTask;
        });
    }
}

