/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.HealthcareRelationEntity;
import com.azure.ai.textanalytics.models.HealthcareEntityRelationType;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class HealthcareRelation
implements JsonSerializable<HealthcareRelation> {
    private HealthcareEntityRelationType relationType;
    private Double confidenceScore;
    private List<HealthcareRelationEntity> entities;

    public HealthcareEntityRelationType getRelationType() {
        return this.relationType;
    }

    public HealthcareRelation setRelationType(HealthcareEntityRelationType relationType) {
        this.relationType = relationType;
        return this;
    }

    public Double getConfidenceScore() {
        return this.confidenceScore;
    }

    public HealthcareRelation setConfidenceScore(Double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    public List<HealthcareRelationEntity> getEntities() {
        return this.entities;
    }

    public HealthcareRelation setEntities(List<HealthcareRelationEntity> entities) {
        this.entities = entities;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("relationType", Objects.toString((Object)this.relationType, null));
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeNumberField("confidenceScore", (Number)this.confidenceScore);
        return jsonWriter.writeEndObject();
    }

    public static HealthcareRelation fromJson(JsonReader jsonReader) throws IOException {
        return (HealthcareRelation)jsonReader.readObject(reader -> {
            HealthcareRelation deserializedHealthcareRelation = new HealthcareRelation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("relationType".equals(fieldName)) {
                    deserializedHealthcareRelation.relationType = HealthcareEntityRelationType.fromString(reader.getString());
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities;
                    deserializedHealthcareRelation.entities = entities = reader.readArray(reader1 -> HealthcareRelationEntity.fromJson(reader1));
                    continue;
                }
                if ("confidenceScore".equals(fieldName)) {
                    deserializedHealthcareRelation.confidenceScore = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedHealthcareRelation;
        });
    }
}

