/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROResultsKind;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseResult;
import com.azure.ai.textanalytics.implementation.models.State;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Objects;

public final class KeyPhraseExtractionLROResult
extends AnalyzeTextLROResult {
    private KeyPhraseResult results;

    public KeyPhraseResult getResults() {
        return this.results;
    }

    public KeyPhraseExtractionLROResult setResults(KeyPhraseResult results) {
        this.results = results;
        return this;
    }

    @Override
    public KeyPhraseExtractionLROResult setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public KeyPhraseExtractionLROResult setLastUpdateDateTime(OffsetDateTime lastUpdateDateTime) {
        super.setLastUpdateDateTime(lastUpdateDateTime);
        return this;
    }

    @Override
    public KeyPhraseExtractionLROResult setStatus(State status) {
        super.setStatus(status);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROResultsKind.KEY_PHRASE_EXTRACTION_LRORESULTS, null));
        jsonWriter.writeStringField("lastUpdateDateTime", Objects.toString(this.getLastUpdateDateTime(), null));
        jsonWriter.writeStringField("status", Objects.toString((Object)this.getStatus(), null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static KeyPhraseExtractionLROResult fromJson(JsonReader jsonReader) throws IOException {
        return (KeyPhraseExtractionLROResult)jsonReader.readObject(reader -> {
            KeyPhraseExtractionLROResult deserializedKeyPhraseExtractionLROResult = new KeyPhraseExtractionLROResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("KeyPhraseExtractionLROResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'KeyPhraseExtractionLROResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("lastUpdateDateTime".equals(fieldName)) {
                    deserializedKeyPhraseExtractionLROResult.setLastUpdateDateTime((OffsetDateTime)reader.getNullable(nonNullReader -> OffsetDateTime.parse(nonNullReader.getString())));
                    continue;
                }
                if ("status".equals(fieldName)) {
                    deserializedKeyPhraseExtractionLROResult.setStatus(State.fromString(reader.getString()));
                    continue;
                }
                if ("taskName".equals(fieldName)) {
                    deserializedKeyPhraseExtractionLROResult.setTaskName(reader.getString());
                    continue;
                }
                if ("results".equals(fieldName)) {
                    deserializedKeyPhraseExtractionLROResult.results = KeyPhraseResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyPhraseExtractionLROResult;
        });
    }
}

