/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.KeyPhraseTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class KeyPhraseLROTask
extends AnalyzeTextLROTask {
    private KeyPhraseTaskParameters parameters;

    public KeyPhraseTaskParameters getParameters() {
        return this.parameters;
    }

    public KeyPhraseLROTask setParameters(KeyPhraseTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public KeyPhraseLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.KEY_PHRASE_EXTRACTION, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static KeyPhraseLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (KeyPhraseLROTask)jsonReader.readObject(reader -> {
            KeyPhraseLROTask deserializedKeyPhraseLROTask = new KeyPhraseLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("KeyPhraseExtraction".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'KeyPhraseExtraction'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedKeyPhraseLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedKeyPhraseLROTask.parameters = KeyPhraseTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedKeyPhraseLROTask;
        });
    }
}

