/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.LanguageDetectionResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class LanguageDetectionTaskResult
extends AnalyzeTextTaskResult {
    private LanguageDetectionResult results;

    public LanguageDetectionResult getResults() {
        return this.results;
    }

    public LanguageDetectionTaskResult setResults(LanguageDetectionResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskResultsKind.LANGUAGE_DETECTION_RESULTS, null));
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static LanguageDetectionTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (LanguageDetectionTaskResult)jsonReader.readObject(reader -> {
            LanguageDetectionTaskResult deserializedLanguageDetectionTaskResult = new LanguageDetectionTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("LanguageDetectionResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'LanguageDetectionResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("results".equals(fieldName)) {
                    deserializedLanguageDetectionTaskResult.results = LanguageDetectionResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLanguageDetectionTaskResult;
        });
    }
}

