/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.LinkedEntity;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

public class LinkedEntitiesDocumentResult
extends DocumentResult {
    private List<LinkedEntity> entities;

    public List<LinkedEntity> getEntities() {
        return this.entities;
    }

    public LinkedEntitiesDocumentResult setEntities(List<LinkedEntity> entities) {
        this.entities = entities;
        return this;
    }

    @Override
    public LinkedEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public LinkedEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public LinkedEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static LinkedEntitiesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (LinkedEntitiesDocumentResult)jsonReader.readObject(reader -> {
            LinkedEntitiesDocumentResult deserializedLinkedEntitiesDocumentResult = new LinkedEntitiesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedLinkedEntitiesDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedLinkedEntitiesDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedLinkedEntitiesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("entities".equals(fieldName)) {
                    List entities;
                    deserializedLinkedEntitiesDocumentResult.entities = entities = reader.readArray(reader1 -> LinkedEntity.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedLinkedEntitiesDocumentResult;
        });
    }
}

