/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.PiiResult;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class PiiTaskResult
extends AnalyzeTextTaskResult {
    private PiiResult results;

    public PiiResult getResults() {
        return this.results;
    }

    public PiiTaskResult setResults(PiiResult results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskResultsKind.PII_ENTITY_RECOGNITION_RESULTS, null));
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static PiiTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (PiiTaskResult)jsonReader.readObject(reader -> {
            PiiTaskResult deserializedPiiTaskResult = new PiiTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("PiiEntityRecognitionResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'PiiEntityRecognitionResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("results".equals(fieldName)) {
                    deserializedPiiTaskResult.results = PiiResult.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedPiiTaskResult;
        });
    }
}

