/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.SentenceAssessment;
import com.azure.ai.textanalytics.implementation.models.SentenceSentimentValue;
import com.azure.ai.textanalytics.implementation.models.SentenceTarget;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class SentenceSentiment
implements JsonSerializable<SentenceSentiment> {
    private String text;
    private SentenceSentimentValue sentiment;
    private SentimentConfidenceScorePerLabel confidenceScores;
    private int offset;
    private int length;
    private List<SentenceTarget> targets;
    private List<SentenceAssessment> assessments;

    public String getText() {
        return this.text;
    }

    public SentenceSentiment setText(String text) {
        this.text = text;
        return this;
    }

    public SentenceSentimentValue getSentiment() {
        return this.sentiment;
    }

    public SentenceSentiment setSentiment(SentenceSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    public SentenceSentiment setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SentenceSentiment setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public SentenceSentiment setLength(int length) {
        this.length = length;
        return this;
    }

    public List<SentenceTarget> getTargets() {
        return this.targets;
    }

    public SentenceSentiment setTargets(List<SentenceTarget> targets) {
        this.targets = targets;
        return this;
    }

    public List<SentenceAssessment> getAssessments() {
        return this.assessments;
    }

    public SentenceSentiment setAssessments(List<SentenceAssessment> assessments) {
        this.assessments = assessments;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("sentiment", Objects.toString((Object)this.sentiment, null));
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.confidenceScores);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeArrayField("targets", this.targets, (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeArrayField("assessments", this.assessments, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SentenceSentiment fromJson(JsonReader jsonReader) throws IOException {
        return (SentenceSentiment)jsonReader.readObject(reader -> {
            SentenceSentiment deserializedSentenceSentiment = new SentenceSentiment();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("text".equals(fieldName)) {
                    deserializedSentenceSentiment.text = reader.getString();
                    continue;
                }
                if ("sentiment".equals(fieldName)) {
                    deserializedSentenceSentiment.sentiment = SentenceSentimentValue.fromString(reader.getString());
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedSentenceSentiment.confidenceScores = SentimentConfidenceScorePerLabel.fromJson(reader);
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    deserializedSentenceSentiment.offset = reader.getInt();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    deserializedSentenceSentiment.length = reader.getInt();
                    continue;
                }
                if ("targets".equals(fieldName)) {
                    List targets;
                    deserializedSentenceSentiment.targets = targets = reader.readArray(reader1 -> SentenceTarget.fromJson(reader1));
                    continue;
                }
                if ("assessments".equals(fieldName)) {
                    List assessments;
                    deserializedSentenceSentiment.assessments = assessments = reader.readArray(reader1 -> SentenceAssessment.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentenceSentiment;
        });
    }
}

