/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.TargetConfidenceScoreLabel;
import com.azure.ai.textanalytics.implementation.models.TargetRelation;
import com.azure.ai.textanalytics.implementation.models.TokenSentimentValue;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class SentenceTarget
implements JsonSerializable<SentenceTarget> {
    private TokenSentimentValue sentiment;
    private TargetConfidenceScoreLabel confidenceScores;
    private int offset;
    private int length;
    private String text;
    private List<TargetRelation> relations;

    public TokenSentimentValue getSentiment() {
        return this.sentiment;
    }

    public SentenceTarget setSentiment(TokenSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    public TargetConfidenceScoreLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    public SentenceTarget setConfidenceScores(TargetConfidenceScoreLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public SentenceTarget setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getLength() {
        return this.length;
    }

    public SentenceTarget setLength(int length) {
        this.length = length;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public SentenceTarget setText(String text) {
        this.text = text;
        return this;
    }

    public List<TargetRelation> getRelations() {
        return this.relations;
    }

    public SentenceTarget setRelations(List<TargetRelation> relations) {
        this.relations = relations;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("sentiment", Objects.toString((Object)this.sentiment, null));
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.confidenceScores);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("relations", this.relations, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SentenceTarget fromJson(JsonReader jsonReader) throws IOException {
        return (SentenceTarget)jsonReader.readObject(reader -> {
            SentenceTarget deserializedSentenceTarget = new SentenceTarget();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("sentiment".equals(fieldName)) {
                    deserializedSentenceTarget.sentiment = TokenSentimentValue.fromString(reader.getString());
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedSentenceTarget.confidenceScores = TargetConfidenceScoreLabel.fromJson(reader);
                    continue;
                }
                if ("offset".equals(fieldName)) {
                    deserializedSentenceTarget.offset = reader.getInt();
                    continue;
                }
                if ("length".equals(fieldName)) {
                    deserializedSentenceTarget.length = reader.getInt();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    deserializedSentenceTarget.text = reader.getString();
                    continue;
                }
                if ("relations".equals(fieldName)) {
                    List relations;
                    deserializedSentenceTarget.relations = relations = reader.readArray(reader1 -> TargetRelation.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentenceTarget;
        });
    }
}

