/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTask;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextLROTaskKind;
import com.azure.ai.textanalytics.implementation.models.SentimentAnalysisTaskParameters;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class SentimentAnalysisLROTask
extends AnalyzeTextLROTask {
    private SentimentAnalysisTaskParameters parameters;

    public SentimentAnalysisTaskParameters getParameters() {
        return this.parameters;
    }

    public SentimentAnalysisLROTask setParameters(SentimentAnalysisTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    @Override
    public SentimentAnalysisLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextLROTaskKind.SENTIMENT_ANALYSIS, null));
        jsonWriter.writeStringField("taskName", this.getTaskName());
        jsonWriter.writeJsonField("parameters", (JsonSerializable)this.parameters);
        return jsonWriter.writeEndObject();
    }

    public static SentimentAnalysisLROTask fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentAnalysisLROTask)jsonReader.readObject(reader -> {
            SentimentAnalysisLROTask deserializedSentimentAnalysisLROTask = new SentimentAnalysisLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("SentimentAnalysis".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'SentimentAnalysis'. The found 'kind' was '" + kind + "'.");
                }
                if ("taskName".equals(fieldName)) {
                    deserializedSentimentAnalysisLROTask.setTaskName(reader.getString());
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    deserializedSentimentAnalysisLROTask.parameters = SentimentAnalysisTaskParameters.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentAnalysisLROTask;
        });
    }
}

