/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.DocumentResult;
import com.azure.ai.textanalytics.implementation.models.DocumentSentimentValue;
import com.azure.ai.textanalytics.implementation.models.DocumentStatistics;
import com.azure.ai.textanalytics.implementation.models.DocumentWarning;
import com.azure.ai.textanalytics.implementation.models.SentenceSentiment;
import com.azure.ai.textanalytics.implementation.models.SentimentConfidenceScorePerLabel;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public class SentimentDocumentResult
extends DocumentResult {
    private DocumentSentimentValue sentiment;
    private SentimentConfidenceScorePerLabel confidenceScores;
    private List<SentenceSentiment> sentences;

    public DocumentSentimentValue getSentiment() {
        return this.sentiment;
    }

    public SentimentDocumentResult setSentiment(DocumentSentimentValue sentiment) {
        this.sentiment = sentiment;
        return this;
    }

    public SentimentConfidenceScorePerLabel getConfidenceScores() {
        return this.confidenceScores;
    }

    public SentimentDocumentResult setConfidenceScores(SentimentConfidenceScorePerLabel confidenceScores) {
        this.confidenceScores = confidenceScores;
        return this;
    }

    public List<SentenceSentiment> getSentences() {
        return this.sentences;
    }

    public SentimentDocumentResult setSentences(List<SentenceSentiment> sentences) {
        this.sentences = sentences;
        return this;
    }

    @Override
    public SentimentDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    @Override
    public SentimentDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    @Override
    public SentimentDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.getId());
        jsonWriter.writeArrayField("warnings", this.getWarnings(), (writer, element) -> writer.writeJson((JsonSerializable)element));
        jsonWriter.writeJsonField("statistics", (JsonSerializable)this.getStatistics());
        jsonWriter.writeStringField("sentiment", Objects.toString((Object)this.sentiment, null));
        jsonWriter.writeJsonField("confidenceScores", (JsonSerializable)this.confidenceScores);
        jsonWriter.writeArrayField("sentences", this.sentences, (writer, element) -> writer.writeJson((JsonSerializable)element));
        return jsonWriter.writeEndObject();
    }

    public static SentimentDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentDocumentResult)jsonReader.readObject(reader -> {
            SentimentDocumentResult deserializedSentimentDocumentResult = new SentimentDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedSentimentDocumentResult.setId(reader.getString());
                    continue;
                }
                if ("warnings".equals(fieldName)) {
                    List warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedSentimentDocumentResult.setWarnings(warnings);
                    continue;
                }
                if ("statistics".equals(fieldName)) {
                    deserializedSentimentDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                    continue;
                }
                if ("sentiment".equals(fieldName)) {
                    deserializedSentimentDocumentResult.sentiment = DocumentSentimentValue.fromString(reader.getString());
                    continue;
                }
                if ("confidenceScores".equals(fieldName)) {
                    deserializedSentimentDocumentResult.confidenceScores = SentimentConfidenceScorePerLabel.fromJson(reader);
                    continue;
                }
                if ("sentences".equals(fieldName)) {
                    List sentences;
                    deserializedSentimentDocumentResult.sentences = sentences = reader.readArray(reader1 -> SentenceSentiment.fromJson(reader1));
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentDocumentResult;
        });
    }
}

