/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.textanalytics.implementation.models;

import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResult;
import com.azure.ai.textanalytics.implementation.models.AnalyzeTextTaskResultsKind;
import com.azure.ai.textanalytics.implementation.models.SentimentResponse;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Objects;

public final class SentimentTaskResult
extends AnalyzeTextTaskResult {
    private SentimentResponse results;

    public SentimentResponse getResults() {
        return this.results;
    }

    public SentimentTaskResult setResults(SentimentResponse results) {
        this.results = results;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", Objects.toString((Object)AnalyzeTextTaskResultsKind.SENTIMENT_ANALYSIS_RESULTS, null));
        jsonWriter.writeJsonField("results", (JsonSerializable)this.results);
        return jsonWriter.writeEndObject();
    }

    public static SentimentTaskResult fromJson(JsonReader jsonReader) throws IOException {
        return (SentimentTaskResult)jsonReader.readObject(reader -> {
            SentimentTaskResult deserializedSentimentTaskResult = new SentimentTaskResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("kind".equals(fieldName)) {
                    String kind = reader.getString();
                    if ("SentimentAnalysisResults".equals(kind)) continue;
                    throw new IllegalStateException("'kind' was expected to be non-null and equal to 'SentimentAnalysisResults'. The found 'kind' was '" + kind + "'.");
                }
                if ("results".equals(fieldName)) {
                    deserializedSentimentTaskResult.results = SentimentResponse.fromJson(reader);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSentimentTaskResult;
        });
    }
}

