// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Supported parameters for the pre-build Abstractive Summarization task.
 */
@Fluent
public final class AbstractiveSummarizationTaskParameters extends AbstractiveSummarizationTaskParametersBase {
    /*
     * The modelVersion property.
     */
    private String modelVersion;

    /*
     * The loggingOptOut property.
     */
    private Boolean loggingOptOut;

    /**
     * Creates an instance of AbstractiveSummarizationTaskParameters class.
     */
    public AbstractiveSummarizationTaskParameters() {
    }

    /**
     * Get the modelVersion property: The modelVersion property.
     * 
     * @return the modelVersion value.
     */
    public String getModelVersion() {
        return this.modelVersion;
    }

    /**
     * Set the modelVersion property: The modelVersion property.
     * 
     * @param modelVersion the modelVersion value to set.
     * @return the AbstractiveSummarizationTaskParameters object itself.
     */
    public AbstractiveSummarizationTaskParameters setModelVersion(String modelVersion) {
        this.modelVersion = modelVersion;
        return this;
    }

    /**
     * Get the loggingOptOut property: The loggingOptOut property.
     * 
     * @return the loggingOptOut value.
     */
    public Boolean isLoggingOptOut() {
        return this.loggingOptOut;
    }

    /**
     * Set the loggingOptOut property: The loggingOptOut property.
     * 
     * @param loggingOptOut the loggingOptOut value to set.
     * @return the AbstractiveSummarizationTaskParameters object itself.
     */
    public AbstractiveSummarizationTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        this.loggingOptOut = loggingOptOut;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractiveSummarizationTaskParameters setSentenceCount(Integer sentenceCount) {
        super.setSentenceCount(sentenceCount);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractiveSummarizationTaskParameters setStringIndexType(StringIndexType stringIndexType) {
        super.setStringIndexType(stringIndexType);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sentenceCount", getSentenceCount());
        jsonWriter.writeStringField("stringIndexType",
            getStringIndexType() == null ? null : getStringIndexType().toString());
        jsonWriter.writeStringField("modelVersion", this.modelVersion);
        jsonWriter.writeBooleanField("loggingOptOut", this.loggingOptOut);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbstractiveSummarizationTaskParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbstractiveSummarizationTaskParameters if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AbstractiveSummarizationTaskParameters.
     */
    public static AbstractiveSummarizationTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbstractiveSummarizationTaskParameters deserializedAbstractiveSummarizationTaskParameters
                = new AbstractiveSummarizationTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sentenceCount".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParameters
                        .setSentenceCount(reader.getNullable(JsonReader::getInt));
                } else if ("stringIndexType".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParameters
                        .setStringIndexType(StringIndexType.fromString(reader.getString()));
                } else if ("modelVersion".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParameters.modelVersion = reader.getString();
                } else if ("loggingOptOut".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParameters.loggingOptOut
                        = reader.getNullable(JsonReader::getBoolean);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbstractiveSummarizationTaskParameters;
        });
    }
}
