// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Supported parameters for an Abstractive Summarization task.
 */
@Fluent
public class AbstractiveSummarizationTaskParametersBase
    implements JsonSerializable<AbstractiveSummarizationTaskParametersBase> {
    /*
     * It controls the approximate number of sentences in the output summaries.
     */
    private Integer sentenceCount;

    /*
     * Specifies the method used to interpret string offsets.  Defaults to Text Elements (Graphemes) according to Unicode v8.0.0. For additional information see https://aka.ms/text-analytics-offsets.
     */
    private StringIndexType stringIndexType;

    /**
     * Creates an instance of AbstractiveSummarizationTaskParametersBase class.
     */
    public AbstractiveSummarizationTaskParametersBase() {
    }

    /**
     * Get the sentenceCount property: It controls the approximate number of sentences in the output summaries.
     * 
     * @return the sentenceCount value.
     */
    public Integer getSentenceCount() {
        return this.sentenceCount;
    }

    /**
     * Set the sentenceCount property: It controls the approximate number of sentences in the output summaries.
     * 
     * @param sentenceCount the sentenceCount value to set.
     * @return the AbstractiveSummarizationTaskParametersBase object itself.
     */
    public AbstractiveSummarizationTaskParametersBase setSentenceCount(Integer sentenceCount) {
        this.sentenceCount = sentenceCount;
        return this;
    }

    /**
     * Get the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     * 
     * @return the stringIndexType value.
     */
    public StringIndexType getStringIndexType() {
        return this.stringIndexType;
    }

    /**
     * Set the stringIndexType property: Specifies the method used to interpret string offsets. Defaults to Text
     * Elements (Graphemes) according to Unicode v8.0.0. For additional information see
     * https://aka.ms/text-analytics-offsets.
     * 
     * @param stringIndexType the stringIndexType value to set.
     * @return the AbstractiveSummarizationTaskParametersBase object itself.
     */
    public AbstractiveSummarizationTaskParametersBase setStringIndexType(StringIndexType stringIndexType) {
        this.stringIndexType = stringIndexType;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeNumberField("sentenceCount", this.sentenceCount);
        jsonWriter.writeStringField("stringIndexType",
            this.stringIndexType == null ? null : this.stringIndexType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbstractiveSummarizationTaskParametersBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbstractiveSummarizationTaskParametersBase if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AbstractiveSummarizationTaskParametersBase.
     */
    public static AbstractiveSummarizationTaskParametersBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbstractiveSummarizationTaskParametersBase deserializedAbstractiveSummarizationTaskParametersBase
                = new AbstractiveSummarizationTaskParametersBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("sentenceCount".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParametersBase.sentenceCount
                        = reader.getNullable(JsonReader::getInt);
                } else if ("stringIndexType".equals(fieldName)) {
                    deserializedAbstractiveSummarizationTaskParametersBase.stringIndexType
                        = StringIndexType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbstractiveSummarizationTaskParametersBase;
        });
    }
}
