// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing a single summary with context for given document.
 */
@Fluent
public final class AbstractiveSummary implements JsonSerializable<AbstractiveSummary> {
    /*
     * The text of the summary.
     */
    private String text;

    /*
     * The context list of the summary.
     */
    private List<SummaryContext> contexts;

    /**
     * Creates an instance of AbstractiveSummary class.
     */
    public AbstractiveSummary() {
    }

    /**
     * Get the text property: The text of the summary.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The text of the summary.
     * 
     * @param text the text value to set.
     * @return the AbstractiveSummary object itself.
     */
    public AbstractiveSummary setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the contexts property: The context list of the summary.
     * 
     * @return the contexts value.
     */
    public List<SummaryContext> getContexts() {
        return this.contexts;
    }

    /**
     * Set the contexts property: The context list of the summary.
     * 
     * @param contexts the contexts value to set.
     * @return the AbstractiveSummary object itself.
     */
    public AbstractiveSummary setContexts(List<SummaryContext> contexts) {
        this.contexts = contexts;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeArrayField("contexts", this.contexts, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbstractiveSummary from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbstractiveSummary if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AbstractiveSummary.
     */
    public static AbstractiveSummary fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbstractiveSummary deserializedAbstractiveSummary = new AbstractiveSummary();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("text".equals(fieldName)) {
                    deserializedAbstractiveSummary.text = reader.getString();
                } else if ("contexts".equals(fieldName)) {
                    List<SummaryContext> contexts = reader.readArray(reader1 -> SummaryContext.fromJson(reader1));
                    deserializedAbstractiveSummary.contexts = contexts;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbstractiveSummary;
        });
    }
}
