// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * An object representing the summarization result of a single document.
 */
@Fluent
public final class AbstractiveSummaryDocumentResult extends DocumentResult {
    /*
     * A list of abstractive summaries.
     */
    private List<AbstractiveSummary> summaries;

    /**
     * Creates an instance of AbstractiveSummaryDocumentResult class.
     */
    public AbstractiveSummaryDocumentResult() {
    }

    /**
     * Get the summaries property: A list of abstractive summaries.
     * 
     * @return the summaries value.
     */
    public List<AbstractiveSummary> getSummaries() {
        return this.summaries;
    }

    /**
     * Set the summaries property: A list of abstractive summaries.
     * 
     * @param summaries the summaries value to set.
     * @return the AbstractiveSummaryDocumentResult object itself.
     */
    public AbstractiveSummaryDocumentResult setSummaries(List<AbstractiveSummary> summaries) {
        this.summaries = summaries;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractiveSummaryDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractiveSummaryDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public AbstractiveSummaryDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeArrayField("summaries", this.summaries, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AbstractiveSummaryDocumentResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AbstractiveSummaryDocumentResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AbstractiveSummaryDocumentResult.
     */
    public static AbstractiveSummaryDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AbstractiveSummaryDocumentResult deserializedAbstractiveSummaryDocumentResult
                = new AbstractiveSummaryDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAbstractiveSummaryDocumentResult.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedAbstractiveSummaryDocumentResult.setWarnings(warnings);
                } else if ("statistics".equals(fieldName)) {
                    deserializedAbstractiveSummaryDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                } else if ("summaries".equals(fieldName)) {
                    List<AbstractiveSummary> summaries
                        = reader.readArray(reader1 -> AbstractiveSummary.fromJson(reader1));
                    deserializedAbstractiveSummaryDocumentResult.summaries = summaries;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAbstractiveSummaryDocumentResult;
        });
    }
}
