// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The AnalyzeTextSentimentAnalysisInput model.
 */
@Fluent
public final class AnalyzeTextSentimentAnalysisInput extends AnalyzeTextTask {
    /*
     * Enumeration of supported Text Analysis tasks.
     */
    private AnalyzeTextTaskKind kind = AnalyzeTextTaskKind.SENTIMENT_ANALYSIS;

    /*
     * The analysisInput property.
     */
    private MultiLanguageAnalysisInput analysisInput;

    /*
     * Supported parameters for a Sentiment Analysis task.
     */
    private SentimentAnalysisTaskParameters parameters;

    /**
     * Creates an instance of AnalyzeTextSentimentAnalysisInput class.
     */
    public AnalyzeTextSentimentAnalysisInput() {
    }

    /**
     * Get the kind property: Enumeration of supported Text Analysis tasks.
     * 
     * @return the kind value.
     */
    @Override
    public AnalyzeTextTaskKind getKind() {
        return this.kind;
    }

    /**
     * Get the analysisInput property: The analysisInput property.
     * 
     * @return the analysisInput value.
     */
    public MultiLanguageAnalysisInput getAnalysisInput() {
        return this.analysisInput;
    }

    /**
     * Set the analysisInput property: The analysisInput property.
     * 
     * @param analysisInput the analysisInput value to set.
     * @return the AnalyzeTextSentimentAnalysisInput object itself.
     */
    public AnalyzeTextSentimentAnalysisInput setAnalysisInput(MultiLanguageAnalysisInput analysisInput) {
        this.analysisInput = analysisInput;
        return this;
    }

    /**
     * Get the parameters property: Supported parameters for a Sentiment Analysis task.
     * 
     * @return the parameters value.
     */
    public SentimentAnalysisTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for a Sentiment Analysis task.
     * 
     * @param parameters the parameters value to set.
     * @return the AnalyzeTextSentimentAnalysisInput object itself.
     */
    public AnalyzeTextSentimentAnalysisInput setParameters(SentimentAnalysisTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("analysisInput", this.analysisInput);
        jsonWriter.writeJsonField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AnalyzeTextSentimentAnalysisInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AnalyzeTextSentimentAnalysisInput if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AnalyzeTextSentimentAnalysisInput.
     */
    public static AnalyzeTextSentimentAnalysisInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AnalyzeTextSentimentAnalysisInput deserializedAnalyzeTextSentimentAnalysisInput
                = new AnalyzeTextSentimentAnalysisInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("kind".equals(fieldName)) {
                    deserializedAnalyzeTextSentimentAnalysisInput.kind
                        = AnalyzeTextTaskKind.fromString(reader.getString());
                } else if ("analysisInput".equals(fieldName)) {
                    deserializedAnalyzeTextSentimentAnalysisInput.analysisInput
                        = MultiLanguageAnalysisInput.fromJson(reader);
                } else if ("parameters".equals(fieldName)) {
                    deserializedAnalyzeTextSentimentAnalysisInput.parameters
                        = SentimentAnalysisTaskParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAnalyzeTextSentimentAnalysisInput;
        });
    }
}
