// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters object for a text analysis task using custom models.
 */
@Fluent
public class CustomTaskParameters extends TaskParameters {
    /*
     * This field indicates the project name for the model.
     */
    private String projectName;

    /*
     * This field indicates the deployment name for the model.
     */
    private String deploymentName;

    /**
     * Creates an instance of CustomTaskParameters class.
     */
    public CustomTaskParameters() {
    }

    /**
     * Get the projectName property: This field indicates the project name for the model.
     * 
     * @return the projectName value.
     */
    public String getProjectName() {
        return this.projectName;
    }

    /**
     * Set the projectName property: This field indicates the project name for the model.
     * 
     * @param projectName the projectName value to set.
     * @return the CustomTaskParameters object itself.
     */
    public CustomTaskParameters setProjectName(String projectName) {
        this.projectName = projectName;
        return this;
    }

    /**
     * Get the deploymentName property: This field indicates the deployment name for the model.
     * 
     * @return the deploymentName value.
     */
    public String getDeploymentName() {
        return this.deploymentName;
    }

    /**
     * Set the deploymentName property: This field indicates the deployment name for the model.
     * 
     * @param deploymentName the deploymentName value to set.
     * @return the CustomTaskParameters object itself.
     */
    public CustomTaskParameters setDeploymentName(String deploymentName) {
        this.deploymentName = deploymentName;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public CustomTaskParameters setLoggingOptOut(Boolean loggingOptOut) {
        super.setLoggingOptOut(loggingOptOut);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("loggingOptOut", isLoggingOptOut());
        jsonWriter.writeStringField("projectName", this.projectName);
        jsonWriter.writeStringField("deploymentName", this.deploymentName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of CustomTaskParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of CustomTaskParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the CustomTaskParameters.
     */
    public static CustomTaskParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            CustomTaskParameters deserializedCustomTaskParameters = new CustomTaskParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("loggingOptOut".equals(fieldName)) {
                    deserializedCustomTaskParameters.setLoggingOptOut(reader.getNullable(JsonReader::getBoolean));
                } else if ("projectName".equals(fieldName)) {
                    deserializedCustomTaskParameters.projectName = reader.getString();
                } else if ("deploymentName".equals(fieldName)) {
                    deserializedCustomTaskParameters.deploymentName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedCustomTaskParameters;
        });
    }
}
