// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The HealthcareAssertion model.
 */
@Fluent
public final class HealthcareAssertion implements JsonSerializable<HealthcareAssertion> {
    /*
     * Describes any conditionality on the entity.
     */
    private Conditionality conditionality;

    /*
     * Describes the entities certainty and polarity.
     */
    private Certainty certainty;

    /*
     * Describes if the entity is the subject of the text or if it describes someone else.
     */
    private Association association;

    /**
     * Creates an instance of HealthcareAssertion class.
     */
    public HealthcareAssertion() {
    }

    /**
     * Get the conditionality property: Describes any conditionality on the entity.
     * 
     * @return the conditionality value.
     */
    public Conditionality getConditionality() {
        return this.conditionality;
    }

    /**
     * Set the conditionality property: Describes any conditionality on the entity.
     * 
     * @param conditionality the conditionality value to set.
     * @return the HealthcareAssertion object itself.
     */
    public HealthcareAssertion setConditionality(Conditionality conditionality) {
        this.conditionality = conditionality;
        return this;
    }

    /**
     * Get the certainty property: Describes the entities certainty and polarity.
     * 
     * @return the certainty value.
     */
    public Certainty getCertainty() {
        return this.certainty;
    }

    /**
     * Set the certainty property: Describes the entities certainty and polarity.
     * 
     * @param certainty the certainty value to set.
     * @return the HealthcareAssertion object itself.
     */
    public HealthcareAssertion setCertainty(Certainty certainty) {
        this.certainty = certainty;
        return this;
    }

    /**
     * Get the association property: Describes if the entity is the subject of the text or if it describes someone else.
     * 
     * @return the association value.
     */
    public Association getAssociation() {
        return this.association;
    }

    /**
     * Set the association property: Describes if the entity is the subject of the text or if it describes someone else.
     * 
     * @param association the association value to set.
     * @return the HealthcareAssertion object itself.
     */
    public HealthcareAssertion setAssociation(Association association) {
        this.association = association;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("conditionality",
            this.conditionality == null ? null : this.conditionality.toString());
        jsonWriter.writeStringField("certainty", this.certainty == null ? null : this.certainty.toString());
        jsonWriter.writeStringField("association", this.association == null ? null : this.association.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HealthcareAssertion from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HealthcareAssertion if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the HealthcareAssertion.
     */
    public static HealthcareAssertion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HealthcareAssertion deserializedHealthcareAssertion = new HealthcareAssertion();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("conditionality".equals(fieldName)) {
                    deserializedHealthcareAssertion.conditionality = Conditionality.fromString(reader.getString());
                } else if ("certainty".equals(fieldName)) {
                    deserializedHealthcareAssertion.certainty = Certainty.fromString(reader.getString());
                } else if ("association".equals(fieldName)) {
                    deserializedHealthcareAssertion.association = Association.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHealthcareAssertion;
        });
    }
}
