// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The HealthcareEntitiesDocumentResult model.
 */
@Fluent
public class HealthcareEntitiesDocumentResult extends DocumentResult {
    /*
     * Healthcare entities.
     */
    private List<HealthcareEntity> entities;

    /*
     * Healthcare entity relations.
     */
    private List<HealthcareRelation> relations;

    /**
     * Creates an instance of HealthcareEntitiesDocumentResult class.
     */
    public HealthcareEntitiesDocumentResult() {
    }

    /**
     * Get the entities property: Healthcare entities.
     * 
     * @return the entities value.
     */
    public List<HealthcareEntity> getEntities() {
        return this.entities;
    }

    /**
     * Set the entities property: Healthcare entities.
     * 
     * @param entities the entities value to set.
     * @return the HealthcareEntitiesDocumentResult object itself.
     */
    public HealthcareEntitiesDocumentResult setEntities(List<HealthcareEntity> entities) {
        this.entities = entities;
        return this;
    }

    /**
     * Get the relations property: Healthcare entity relations.
     * 
     * @return the relations value.
     */
    public List<HealthcareRelation> getRelations() {
        return this.relations;
    }

    /**
     * Set the relations property: Healthcare entity relations.
     * 
     * @param relations the relations value to set.
     * @return the HealthcareEntitiesDocumentResult object itself.
     */
    public HealthcareEntitiesDocumentResult setRelations(List<HealthcareRelation> relations) {
        this.relations = relations;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HealthcareEntitiesDocumentResult setId(String id) {
        super.setId(id);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HealthcareEntitiesDocumentResult setWarnings(List<DocumentWarning> warnings) {
        super.setWarnings(warnings);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public HealthcareEntitiesDocumentResult setStatistics(DocumentStatistics statistics) {
        super.setStatistics(statistics);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", getId());
        jsonWriter.writeArrayField("warnings", getWarnings(), (writer, element) -> writer.writeJson(element));
        jsonWriter.writeJsonField("statistics", getStatistics());
        jsonWriter.writeArrayField("entities", this.entities, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeArrayField("relations", this.relations, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HealthcareEntitiesDocumentResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HealthcareEntitiesDocumentResult if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HealthcareEntitiesDocumentResult.
     */
    public static HealthcareEntitiesDocumentResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HealthcareEntitiesDocumentResult deserializedHealthcareEntitiesDocumentResult
                = new HealthcareEntitiesDocumentResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedHealthcareEntitiesDocumentResult.setId(reader.getString());
                } else if ("warnings".equals(fieldName)) {
                    List<DocumentWarning> warnings = reader.readArray(reader1 -> DocumentWarning.fromJson(reader1));
                    deserializedHealthcareEntitiesDocumentResult.setWarnings(warnings);
                } else if ("statistics".equals(fieldName)) {
                    deserializedHealthcareEntitiesDocumentResult.setStatistics(DocumentStatistics.fromJson(reader));
                } else if ("entities".equals(fieldName)) {
                    List<HealthcareEntity> entities = reader.readArray(reader1 -> HealthcareEntity.fromJson(reader1));
                    deserializedHealthcareEntitiesDocumentResult.entities = entities;
                } else if ("relations".equals(fieldName)) {
                    List<HealthcareRelation> relations
                        = reader.readArray(reader1 -> HealthcareRelation.fromJson(reader1));
                    deserializedHealthcareEntitiesDocumentResult.relations = relations;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHealthcareEntitiesDocumentResult;
        });
    }
}
