// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The HealthcareEntityLink model.
 */
@Fluent
public final class HealthcareEntityLink implements JsonSerializable<HealthcareEntityLink> {
    /*
     * Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     */
    private String dataSource;

    /*
     * Entity id in the given source catalog.
     */
    private String id;

    /**
     * Creates an instance of HealthcareEntityLink class.
     */
    public HealthcareEntityLink() {
    }

    /**
     * Get the dataSource property: Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     * 
     * @return the dataSource value.
     */
    public String getDataSource() {
        return this.dataSource;
    }

    /**
     * Set the dataSource property: Entity Catalog. Examples include: UMLS, CHV, MSH, etc.
     * 
     * @param dataSource the dataSource value to set.
     * @return the HealthcareEntityLink object itself.
     */
    public HealthcareEntityLink setDataSource(String dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    /**
     * Get the id property: Entity id in the given source catalog.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Entity id in the given source catalog.
     * 
     * @param id the id value to set.
     * @return the HealthcareEntityLink object itself.
     */
    public HealthcareEntityLink setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("dataSource", this.dataSource);
        jsonWriter.writeStringField("id", this.id);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of HealthcareEntityLink from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of HealthcareEntityLink if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the HealthcareEntityLink.
     */
    public static HealthcareEntityLink fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            HealthcareEntityLink deserializedHealthcareEntityLink = new HealthcareEntityLink();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("dataSource".equals(fieldName)) {
                    deserializedHealthcareEntityLink.dataSource = reader.getString();
                } else if ("id".equals(fieldName)) {
                    deserializedHealthcareEntityLink.id = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedHealthcareEntityLink;
        });
    }
}
