// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An object representing the task definition for a Key Phrase Extraction task.
 */
@Fluent
public final class KeyPhraseLROTask extends AnalyzeTextLROTask {
    /*
     * Enumeration of supported long-running Text Analysis tasks.
     */
    private AnalyzeTextLROTaskKind kind = AnalyzeTextLROTaskKind.KEY_PHRASE_EXTRACTION;

    /*
     * Supported parameters for a Key Phrase Extraction task.
     */
    private KeyPhraseTaskParameters parameters;

    /**
     * Creates an instance of KeyPhraseLROTask class.
     */
    public KeyPhraseLROTask() {
    }

    /**
     * Get the kind property: Enumeration of supported long-running Text Analysis tasks.
     * 
     * @return the kind value.
     */
    @Override
    public AnalyzeTextLROTaskKind getKind() {
        return this.kind;
    }

    /**
     * Get the parameters property: Supported parameters for a Key Phrase Extraction task.
     * 
     * @return the parameters value.
     */
    public KeyPhraseTaskParameters getParameters() {
        return this.parameters;
    }

    /**
     * Set the parameters property: Supported parameters for a Key Phrase Extraction task.
     * 
     * @param parameters the parameters value to set.
     * @return the KeyPhraseLROTask object itself.
     */
    public KeyPhraseLROTask setParameters(KeyPhraseTaskParameters parameters) {
        this.parameters = parameters;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public KeyPhraseLROTask setTaskName(String taskName) {
        super.setTaskName(taskName);
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("taskName", getTaskName());
        jsonWriter.writeStringField("kind", this.kind == null ? null : this.kind.toString());
        jsonWriter.writeJsonField("parameters", this.parameters);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of KeyPhraseLROTask from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of KeyPhraseLROTask if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IOException If an error occurs while reading the KeyPhraseLROTask.
     */
    public static KeyPhraseLROTask fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            KeyPhraseLROTask deserializedKeyPhraseLROTask = new KeyPhraseLROTask();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("taskName".equals(fieldName)) {
                    deserializedKeyPhraseLROTask.setTaskName(reader.getString());
                } else if ("kind".equals(fieldName)) {
                    deserializedKeyPhraseLROTask.kind = AnalyzeTextLROTaskKind.fromString(reader.getString());
                } else if ("parameters".equals(fieldName)) {
                    deserializedKeyPhraseLROTask.parameters = KeyPhraseTaskParameters.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedKeyPhraseLROTask;
        });
    }
}
