// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The LanguageInput model.
 */
@Fluent
public final class LanguageInput implements JsonSerializable<LanguageInput> {
    /*
     * Unique, non-empty document identifier.
     */
    private String id;

    /*
     * The text property.
     */
    private String text;

    /*
     * The countryHint property.
     */
    private String countryHint;

    /**
     * Creates an instance of LanguageInput class.
     */
    public LanguageInput() {
    }

    /**
     * Get the id property: Unique, non-empty document identifier.
     * 
     * @return the id value.
     */
    public String getId() {
        return this.id;
    }

    /**
     * Set the id property: Unique, non-empty document identifier.
     * 
     * @param id the id value to set.
     * @return the LanguageInput object itself.
     */
    public LanguageInput setId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the text property: The text property.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: The text property.
     * 
     * @param text the text value to set.
     * @return the LanguageInput object itself.
     */
    public LanguageInput setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the countryHint property: The countryHint property.
     * 
     * @return the countryHint value.
     */
    public String getCountryHint() {
        return this.countryHint;
    }

    /**
     * Set the countryHint property: The countryHint property.
     * 
     * @param countryHint the countryHint value to set.
     * @return the LanguageInput object itself.
     */
    public LanguageInput setCountryHint(String countryHint) {
        this.countryHint = countryHint;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeStringField("countryHint", this.countryHint);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of LanguageInput from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of LanguageInput if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the LanguageInput.
     */
    public static LanguageInput fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            LanguageInput deserializedLanguageInput = new LanguageInput();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedLanguageInput.id = reader.getString();
                } else if ("text".equals(fieldName)) {
                    deserializedLanguageInput.text = reader.getString();
                } else if ("countryHint".equals(fieldName)) {
                    deserializedLanguageInput.countryHint = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedLanguageInput;
        });
    }
}
