// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.ai.textanalytics.implementation.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The Match model.
 */
@Fluent
public final class Match implements JsonSerializable<Match> {
    /*
     * If a well known item is recognized, a decimal number denoting the confidence level between 0 and 1 will be returned.
     */
    private double confidenceScore;

    /*
     * Entity text as appears in the request.
     */
    private String text;

    /*
     * Start position for the entity match text.
     */
    private int offset;

    /*
     * Length for the entity match text.
     */
    private int length;

    /**
     * Creates an instance of Match class.
     */
    public Match() {
    }

    /**
     * Get the confidenceScore property: If a well known item is recognized, a decimal number denoting the confidence
     * level between 0 and 1 will be returned.
     * 
     * @return the confidenceScore value.
     */
    public double getConfidenceScore() {
        return this.confidenceScore;
    }

    /**
     * Set the confidenceScore property: If a well known item is recognized, a decimal number denoting the confidence
     * level between 0 and 1 will be returned.
     * 
     * @param confidenceScore the confidenceScore value to set.
     * @return the Match object itself.
     */
    public Match setConfidenceScore(double confidenceScore) {
        this.confidenceScore = confidenceScore;
        return this;
    }

    /**
     * Get the text property: Entity text as appears in the request.
     * 
     * @return the text value.
     */
    public String getText() {
        return this.text;
    }

    /**
     * Set the text property: Entity text as appears in the request.
     * 
     * @param text the text value to set.
     * @return the Match object itself.
     */
    public Match setText(String text) {
        this.text = text;
        return this;
    }

    /**
     * Get the offset property: Start position for the entity match text.
     * 
     * @return the offset value.
     */
    public int getOffset() {
        return this.offset;
    }

    /**
     * Set the offset property: Start position for the entity match text.
     * 
     * @param offset the offset value to set.
     * @return the Match object itself.
     */
    public Match setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    /**
     * Get the length property: Length for the entity match text.
     * 
     * @return the length value.
     */
    public int getLength() {
        return this.length;
    }

    /**
     * Set the length property: Length for the entity match text.
     * 
     * @param length the length value to set.
     * @return the Match object itself.
     */
    public Match setLength(int length) {
        this.length = length;
        return this;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeDoubleField("confidenceScore", this.confidenceScore);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeIntField("offset", this.offset);
        jsonWriter.writeIntField("length", this.length);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of Match from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of Match if the JsonReader was pointing to an instance of it, or null if it was pointing to
     * JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the Match.
     */
    public static Match fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            Match deserializedMatch = new Match();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("confidenceScore".equals(fieldName)) {
                    deserializedMatch.confidenceScore = reader.getDouble();
                } else if ("text".equals(fieldName)) {
                    deserializedMatch.text = reader.getString();
                } else if ("offset".equals(fieldName)) {
                    deserializedMatch.offset = reader.getInt();
                } else if ("length".equals(fieldName)) {
                    deserializedMatch.length = reader.getInt();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedMatch;
        });
    }
}
